/*------------------------------------------------------------------------------*
 * File Name: PEPageListControl.h Project Explorer Control						*
 * Creation: 																	*
 * Purpose: A Control base class for showing a list of pages 					*
 * Copyright (c) Originlab Corp., 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Folger 11/07/07 COLUMN_HEADING_LOCALIZE										*
 *------------------------------------------------------------------------------*/
#ifndef _PAGE_CONTTROL_H
#define _PAGE_CONTTROL_H

enum {PEPAGE_LONGNAME, PEPAGE_SHORTNAME, PEPAGE_TYPE,PEPAGE_VIEW, PEPAGE_SIZE,PEPAGE_TOTAL_COLS};
//------ Folger 11/07/07 COLUMN_HEADING_LOCALIZE
//#define PAGE_LIST_COL_HEADER		"Long Name|Short Name|Type|View|Size"
#ifndef _CAT
#define _CAT "PEPages"
#endif
#define PAGE_LIST_COL_HEADER		_LC("Long Name|Short Name|Type|View|Size", _CAT)
//------ End COLUMN_HEADING_LOCALIZE
enum
{
	ITEM_IS_PAGE = 0,
	ITEM_IS_FOLDER,
	ITEM_IS_NULL	
};
class PEPageListControl : public GridListControl
{
	PEPageListControl()
	{
		//------ Folger 11/07/07 COLUMN_HEADING_LOCALIZE
		//GetFormatStrAsArray(PAGE_LIST_COL_HEADER, m_vsColHeadings, "PEPages");
		GetFormatStrAsArray(PAGE_LIST_COL_HEADER, m_vsColHeadings, _CAT);
		//------ End COLUMN_HEADING_LOCALIZE
	}
	
public:
	void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName )
	{
		m_strDlgName = lpcszDlgName;
		vector<byte> vbDefaultShowCols = {0,0,0,0,0};		
		GridListControl::Init(nID, dlg);

		m_flx.Cols = PEPAGE_TOTAL_COLS;
		m_flx.FormatString = makeColHeadings();
		m_flx.SelectionMode = flexSelectionListBox;
		m_flx.AllowSelection = true;
		m_flx.ExplorerBar = flexExSortShow;
		m_flx.Ellipsis = flexEllipsisPath;// if str too long, show ... in the middle
		LoadHideCols(m_strDlgName, "PageListHideShowCols", &vbDefaultShowCols);

		m_bShowHidden = true;
		m_bShowMinimized = true;
	}
	//virtual 
	string GetRuntimeClass()
	{
		return "PEPageListControl";
	}
	BOOL OnDestroy()
	{
		SaveHideCols();
		return TRUE;
	}
	void ChangeShowOption(bool bShowHiddenPages = true, bool bShowMinimized = true)
	{
		m_bShowHidden = bShowHiddenPages ? !m_bShowHidden : m_bShowHidden;
		m_bShowMinimized = bShowMinimized ? !m_bShowMinimized : m_bShowMinimized;		
	}
	int IsPage(int nRow)
	{
		string strType;
		strType =GetCell(nRow,PEPAGE_TYPE);
		if(strType.IsEmpty())
			return ITEM_IS_NULL;
		
		if(strType.CompareNoCase("Folder") == 0)
			return ITEM_IS_FOLDER;
			
		return ITEM_IS_PAGE;
	}
	bool GetSelItems(vector<string>& vsWksNames)
	{
		vector<uint> vnRows;
		vsWksNames.SetSize(0);
		string strShortName, strLongName;
		string strItemType;
		if(GetSelRows(vnRows))
		{
			//for(int ii = 1; ii < vnRows.GetSize(); ii++)
			for(int ii = 0; ii < vnRows.GetSize(); ii++)
			{
				//if(IsPage(vnRows[ii]) != ITEM_IS_PAGE )
				if(IsPage(vnRows[ii]) != ITEM_IS_PAGE || vnRows[ii] == 0)
					continue;
				
				strShortName = GetCell(flexcpText, vnRows[ii], PEPAGE_SHORTNAME);
				strLongName = GetCell(flexcpText, vnRows[ii], PEPAGE_LONGNAME);
				if(strShortName.IsEmpty())
					strShortName = strLongName.MakeValidCName();
				
				vsWksNames.Add(strShortName);
			}
			return true;
		}
		return false;
	}
	///Frank 9/13/05 SUPPORT_SELECT_ALL	
	void GetAllPages(vector<int> &nRows)
	{
		nRows.RemoveAll();
		
		for(int ii = GetRowOffset(); ii < GetRows(); ii++)
		{
			if(IsPage(ii) != ITEM_IS_PAGE || ii == 0)
				continue;
			
			nRows.Add(ii);
		}
	}
	///End SUPPORT_SELECT_ALL	
protected:
	void ResizeCols(int nMaxColSizeFactor = 0, int nExtraPixcels = 8)
	{
		GridListControl::ResizeCols(nMaxColSizeFactor, nExtraPixcels);
	}
	void AddPages(Folder fldr, int nPageType = 0)
	{
		foreach(PageBase page in fldr.Pages)
		{
			if(nPageType && page.GetType() != nPageType)
				continue;
			
			AddPage(page, page.GetType());
		}
	}
	bool AddPage(PageBase pg, int nPageType)
	{
		//if(pg)
		if(pg && pageCanBeAdd(pg))
		{
			m_flx.AddItem(makeRow(pg));
			SetCellIcon(m_flx.Rows - 1, 0, getDisplayIdFromPageID(pg.GetType()), MODULE_ORIGIN);//TD 3-30-04
			return true;
		}
		return false;
	}
	bool DelPage(int nRow)///PageBase &pg)
	{
		return 	DeleteRow();
	}
	bool RenamePage(int nRow, LPCSTR lpcszNewName)//LPCSTR lpcszOldName
	{
		return changeCellValue(nRow,PEPAGE_LONGNAME, lpcszNewName);
	}
	bool SetPageShow(int nRow, int nNewShow = PAGE_ACTIVATE)
	{
		string strNewShow ;
		switch(nNewShow)
		{
		case PAGE_NORMAL:
			strNewShow = "Normal";
			break;
		case PAGE_MINIMIZED:
			strNewShow = "Minimized";
			break;
		case PAGE_MAXIMIZED:
			strNewShow = "Maximized";
			break;
		case PAGE_HIDDEN:
			strNewShow = "Hidden";
			break;
		case PAGE_ACTIVATE:
			strNewShow = "Normal"; /// Need to check the active show state
			break;
		}

		return changeCellValue(nRow,PEPAGE_VIEW, strNewShow);
	}
private:
	bool changeCellValue(int nRow, int nCol, const string& str)
	{
		if(nRow <= 0) // need to check the header line
			return false;
		
		return	SetCell(nRow,PEPAGE_VIEW, str);	
	}
	
	bool pageCanBeAdd(PageBase &pb)
	{
		int nView = pb.GetShow();
		if(!m_bShowHidden && nView == PAGE_HIDDEN || !m_bShowMinimized && nView == PAGE_MINIMIZED)
			return false;
		return true;
	}
	
	int getDisplayIdFromPageID(int nPageId)
	{
	switch(nPageId)
		{
		case EXIST_GRAPH:
			return IDR_GRAPHTYPE_V8;
		case EXIST_WKS:
			return IDR_WORKSHEETTYPE_V8;
		case EXIST_NOTES:
			return IDR_NOTESTYPE;
		case EXIST_EXTERN_WKS:
			return IDR_EXCELTYPE;
		case EXIST_MATRIX:
			return IDR_MATRIXTYPE_V8;
		case EXIST_LAYOUT:
			return IDR_LAYOUTTYPE;
		};
		return IDI_FOLDER_CLOSED;

	}
	string makeCol(PageBase pg, int nColType)
	{
		Page page = pg;

		string strTemp;
		switch(nColType)
		{
		case PEPAGE_SHORTNAME:
			return pg.GetName();
		case PEPAGE_LONGNAME: // long name, if label empty, use tagName
			return page_get_display_name(pg);
		case PEPAGE_TYPE:
			return getPageTypeName(pg.GetType());
		case PEPAGE_VIEW:
			return getPageShowState(pg.GetShow());
		case PEPAGE_SIZE:
			return getPageSize(pg);
		default:
			break;
		}
		
		return strTemp;// return empty
	}
	string getPageTypeName(int nPageType)
	{
		switch(nPageType)
		{
		case EXIST_GRAPH:
			return "Graph";
		case EXIST_WKS:
			return "Workbook";
		case EXIST_NOTES:
			return "Notes";
		case EXIST_EXTERN_WKS:
			return "Workbook";
		case EXIST_MATRIX:
			return "Matrix";
		case EXIST_LAYOUT:
			return "Layout";
		default:
			break:
		};
		return "Folder";

	}		
	///PAGE_NORMAL, PAGE_MINIMIZED, PAGE_MAXIMIZED, PAGE_HIDDEN
	string getPageShowState(int nShowState = PAGE_NORMAL)
	{
		string strShow = "Normal";
		switch(nShowState)
		{
		case PAGE_NORMAL:
			break;
		case PAGE_MINIMIZED:
			strShow = "Minimized";
			break;
		case PAGE_MAXIMIZED:
			strShow = "Maxinmized";
			break;
		case PAGE_HIDDEN:
			strShow = "Hidden";
			break;
		}
		return strShow;		
	}
	
	string getPageSize(const PageBase &pb)
	{
		if(!pb)
			return -1;
		
		PageSystemInfo PgInfo;
		bool bb = pb.GetPageSystemInfo(&PgInfo);
		
		int nSize = PgInfo.nSize;

		return (string) nSize;
	}
	string makeRow(PageBase wkspg)
	{
		string	str;// = wkspg.GetName() + "\t" + wkspg.Label;
		int	nCols = m_vsColHeadings.GetSize();
		for(int ii = 0; ii < nCols; ii++)
		{
			str += makeCol(wkspg, ii);
			if(ii < nCols -1)
				str += "\t";
		}
		return str;
	}

	string makeColHeadings()
	{
		string str;
		int	nCols = m_vsColHeadings.GetSize();
		for(int ii = 0; ii < nCols; ii++)
		{
			str += m_vsColHeadings[ii];
			if(ii < nCols -1)
				str += "|";
		}
		return str;
	}
private:
	bool			m_bShowHidden;
	bool			m_bShowMinimized;
	
	vector<string>	m_vsColHeadings;
	string			m_strDlgName;
protected:
	int				m_nNameCol;
};

#endif //_PAGE_CONTTROL_H

